DROP TABLE IF EXISTS language;

-- DROP SEQUENCE IF EXISTS language_language_id_seq;
-- CREATE SEQUENCE language_language_id_seq;


CREATE TABLE language (
  "language_id" int PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY, -- SERIAL PRIMARY KEY
  "name" varchar(64) NOT NULL,
  "code" varchar(12) NOT NULL,
  "locale" varchar(20) NOT NULL,
  "slug" varchar(12) NOT NULL,
  "rtl" smallint NOT NULL DEFAULT 0,
  "sort_order" int NOT NULL DEFAULT 0,
  "status" smallint NOT NULL,
  "default" smallint NOT NULL DEFAULT 0
  -- PRIMARY KEY("language_id")
);

CREATE INDEX "language_name" ON language ("name");
SELECT setval('language_language_id_seq', 8, true); -- last inserted id by sample data