Vvveb.ComponentsGroup['Plugins'] = Vvveb.ComponentsGroup['Plugins'] ?? [];
Vvveb.ComponentsGroup['Plugins'].push("newsletter/form");

Vvveb.Components.extend("_base", "newsletter/form", {
    image: "icons/envelope.svg",
    name: "Newsletter",
    attributes: ["data-v-component-plugin-newsletter-form"],
    html: `<div data-v-component-plugin-newsletter-form data-v-storage="database" data-v-name="subscribe-footer" data-v-list="footer">
			<div class="row h-100 d-flex justify-content-center align-items-center">
				
				<div class="col-md-6">
					<h5 class="mb-3">Stay Informed with Early Updates!</h5>
					<p class="text-muted">Subscribe to our newsletter and receive the latest updates and important news directly to your inbox.</p>
				</div>
				
				<div class="col-md-6">
					
					<div class="notifications" data-v-notifications>

						<div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-if="this.errors">

							<div class="icon align-middle me-2">
								<i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
							</div>

							<div class="flex-grow-1 align-self-center text-small" >
								<div data-v-notification-error>
									<div data-v-notification-text>
										This is a placeholder for an error message.
									</div>
								</div>
							</div>


							<button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">
									<!-- <i class="la la-times"></i> -->
								</span>
							</button>
						</div>

						<div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success>

							<div class="icon align-middle me-2">
								<i class="align-middle la la-2x lh-1 la-check-circle"></i>
							</div>

							<div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
								This is a placeholder for a success message.
							</div>

							<button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">
									<!-- <i class="la la-times"></i> -->
								</span>
							</button>
						</div>


					</div>

					<form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-newsletter-form]" data-v-vvveb-on="submit">
					  <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">	
					  <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>	
					  <input type="hidden" class="form-control" name="form-name" value="subscribe-footer">
							
					<div class="search position-relative">
						<input class="form-control" name="email" placeholder="Your email address">
						<button type="submit" class="btn btn-primary position-absolute">
						
							<span class="loading d-none">
								<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
								</span>
								<span>Submitting</span> ...
							</span>

							<span class="button-text">
								<span>Submit</span><i class="la la-lg la-envelope opacity-50 ms-2"></i>
							</span>
						
						</button>
					</div>
					
					<label class="small mt-2 text-muted form-check">
						<input type="checkbox" class="form-check-input" value="1" name="optin" required>
						<span class="form-check-label">I agree to receive your newsletters and accept the data privacy statement.</span>
					</label>

					
					 <input type="text" class="form-control d-none" placeholder="Contact form" name="newsletter" >	
					 
					 <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty" >	
					 
					 <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">	
					
					</form>
					
				</div>
				
			</div>
			
		</div>`,
    
    properties: [{
        name: "Name",
        key: "name",
        htmlAttr: "data-v-name",
        inputtype: TextInput
    },{
        name: "List name",
        key: "list",
        htmlAttr: "data-v-list",
        inputtype: TextInput
	}]
});    
