DROP TABLE IF EXISTS `subscription`;

CREATE TABLE `subscription` (
  `subscription_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` int(10) UNSIGNED NOT NULL,
  `order_product_id` int(10) UNSIGNED NOT NULL,
  `site_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `payment_address_id` int(10) UNSIGNED NOT NULL,
  `payment_method` text NOT NULL,
  `shipping_address_id` int(10) UNSIGNED NOT NULL,
  `shipping_method` text NOT NULL,
  `product_id` int(10) UNSIGNED NOT NULL,
  `quantity` int(4) NOT NULL,
  `subscription_plan_id` int(10) UNSIGNED NOT NULL,
  `price` decimal(10,4) NOT NULL,
  `period` enum('day','week','month','year') NOT NULL,
  `cycle` smallint(6) NOT NULL,
  `length` smallint(6) NOT NULL,
  `left` smallint(6) NOT NULL,
  `trial_price` decimal(10,4) NOT NULL,
  `trial_period` enum('day','week','month','year') NOT NULL,
  `trial_cycle` smallint(6) NOT NULL,
  `trial_length` smallint(6) NOT NULL,
  `trial_left` smallint(6) NOT NULL,
  `trial_status` tinyint NOT NULL,
  `date_next` datetime NOT NULL,
  `subscription_status_id` int(10) UNSIGNED NOT NULL,
  `notes` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`subscription_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;
